function createCell(key)

if isstr(key)
  key = eval(key);
end

% GTABLE is the table of parameter for generating the model
params = fieldnames(key.gen);
for i = 1:numel(params)
  gtable{i,1} = params{i};
  gtable{i,2} = num2str(key.gen.(params{i}),'%0.15g');
end
i = numel(params) + 1;
gtable{i,1} = 'oneDT';
gtable{i,2} = num2str(key.time.oneDT,'%0.15g');
gtable{i+1,1} = 'sqrtDT';
gtable{i+1,2} = num2str(key.time.sqrtDT,'%0.15g');
% ATABLE is the table of assume values for fitting (incl assumed correct)
atable = gtable;
assumes = fieldnames(key.assume);
for j = 1:numel(assumes)
  for i = 1:numel(params)
    if strcmp(assumes{j},params{i})
      atable{i,2} = num2str(key.assume.(assumes{j}),'%0.15g');
    end
  end
end
% PTABLE is the table of strings for substituting in fitting code
% ICP is the initial parameters for optimization
ptable = atable;
for j = 1:numel(key.fit)
  for i = 1:numel(params)
    if strcmp(key.fit{j},params{i})
      ptable{i,2} = ['param(',num2str(j),')'];
      icp(j) = eval(atable{i,2});  % initial parameter guesses
    end
  end
end
% STABLE is the state substitution table
% ICS is the initial conditions for the state
states = fieldnames(key.state);
for i = 1:numel(states)
  stable{i,1} = states{i};
  stable{i,2} = ['state(',num2str(i),')'];
  ics(i) = key.state.(states{i});  % initial conditions for states
end
ica = ics;  % Assumed initial condition for states
for j = 1:numel(assumes)
  for i = 1:numel(states)
    if strcmp(assumes{j},states{i})
      ica(i) = key.assume.(assumes{j});
    end
  end
end
% ITABLE is input substitution table
for i = 1:numel(key.input)
  itable{i,1} = key.input{i};
  itable{i,2} = ['input(',num2str(i),')'];
end 
% NTABLE is process noise substitution table
for i = 1:numel(key.noise.process)
  ntable{i,1} = key.noise.process{i};
  ntable{i,2} = ['noise(',num2str(i),')'];
end 
% MTABLE is measurement noise substitution table
for i = 1:numel(key.noise.measurement)
  mtable{i,1} = key.noise.measurement{i};
  mtable{i,2} = ['noise(',num2str(i),')'];
end 

readfid = fopen(key.steptemplate,'r');
writefid = fopen([key.prefix,'_step_gen.m'],'w');
S = 'string';
while ischar(S)
  S = fgetl(readfid);
  if ischar(S)
    for i = 1:size(gtable,1)
      S = strrep(S,gtable{i,1},gtable{i,2});
    end   
    for i = 1:size(stable,1)
      S = strrep(S,stable{i,1},stable{i,2});
    end   
    for i = 1:size(itable,1)
      S = strrep(S,itable{i,1},itable{i,2});
    end   
    for i = 1:size(ntable,1)
      S = strrep(S,ntable{i,1},ntable{i,2});
    end   
    S = strrep(S,'template','gen');
    if ~isempty(key.debug)
      S = strrep(S,'function nextState','function [nextState,debug]');
    end
    fprintf(writefid,'%s\n',S);
  end
end
fclose(readfid);
if ~isempty(key.debug)
  fprintf(writefid,'%s\n','debug = [ ...');
  for j = 1:numel(key.debug)
    fprintf(writefid,'%s; ...\n',key.debug{j});
  end
  fprintf(writefid,'%s\n','];');
end
fclose(writefid);


readfid = fopen(key.steptemplate,'r');
writefid = fopen([key.prefix,'_step_fit.m'],'w');
S = 'string';
while ischar(S)
  S = fgetl(readfid);
  if ischar(S)
    for i = 1:size(ptable,1)
      S = strrep(S,ptable{i,1},ptable{i,2});
    end   
    for i = 1:size(stable,1)
      S = strrep(S,stable{i,1},stable{i,2});
    end   
    for i = 1:size(itable,1)
      S = strrep(S,itable{i,1},itable{i,2});
    end   
    for i = 1:size(ntable,1)
      S = strrep(S,ntable{i,1},ntable{i,2});
    end   
    S = strrep(S,'template','fit');
    fprintf(writefid,'%s\n',S);
  end
end
fclose(readfid);
fclose(writefid);


readfid = fopen(key.meastemplate,'r');
writefid = fopen([key.prefix,'_meas_gen.m'],'w');
S = 'string';
while ischar(S)
  S = fgetl(readfid);
  if ischar(S)
    for i = 1:size(gtable,1)
      S = strrep(S,ptable{i,1},ptable{i,2});
    end   
    for i = 1:size(stable,1)
      S = strrep(S,stable{i,1},stable{i,2});
    end   
    for i = 1:size(itable,1)
      S = strrep(S,itable{i,1},itable{i,2});
    end   
    for i = 1:size(mtable,1)
      S = strrep(S,mtable{i,1},mtable{i,2});
    end   
    S = strrep(S,'template','gen');
    fprintf(writefid,'%s\n',S);
  end
end
fclose(readfid);
fclose(writefid);


readfid = fopen(key.meastemplate,'r');
writefid = fopen([key.prefix,'_meas_fit.m'],'w');
S = 'string';
while ischar(S)
  S = fgetl(readfid);
  if ischar(S)
    for i = 1:size(gtable,1)
      S = strrep(S,ptable{i,1},ptable{i,2});
    end   
    for i = 1:size(stable,1)
      S = strrep(S,stable{i,1},stable{i,2});
    end   
    for i = 1:size(itable,1)
      S = strrep(S,itable{i,1},itable{i,2});
    end   
    for i = 1:size(mtable,1)
      S = strrep(S,mtable{i,1},mtable{i,2});
    end   
    S = strrep(S,'template','fit');
    fprintf(writefid,'%s\n',S);
  end
end
fclose(readfid);
fclose(writefid);

writefid = fopen([key.prefix,'_ics.m'],'w');
fprintf(writefid,'%s\n',['function [par,state,astate] = ',key.prefix,'_ics']);
fprintf(writefid,'%s\n','par = [');
for i = 1:numel(icp)
  fprintf(writefid,'%s\n',[num2str(icp(i),'%0.15g'),' ...']);
end
fprintf(writefid,'%s\n','];');
fprintf(writefid,'%s\n','state = [');
for i = 1:numel(ics)
  fprintf(writefid,'%s\n',[num2str(ics(i),'%0.15g'),' ...']);
end
fprintf(writefid,'%s\n','];');
fprintf(writefid,'%s\n','astate = [');
for i = 1:numel(ica)
  fprintf(writefid,'%s\n',[num2str(ica(i),'%0.15g'),' ...']);
end
fprintf(writefid,'%s\n','];');
fclose(writefid);

