function LSplot(m,b,pdata)
% PLOT LEAST-SQUARES COST FUNCTION FOR BESTLINE
% function LSplot(m,b,pdata)

subplot(1,1,1)
hold off

Xdata = pdata.Xdata;
Ydata = pdata.Ydata;
nm = numel(m);
nb = numel(b);
cost = zeros(nb,nm);

for i = 1:nm
  for j = 1:nb
    errs = polyval([m(i),b(j)],Xdata) - Ydata;
    cost(j,i) = sum(errs.^2);
  end
end

% surf(m,b,cost)
% disp('Press any key');
% pause;
[C,H] = contour(m,b,cost);
set(H,'LineWidth',2);
H = xlabel('m');
set(H,'FontSize',14);
H = ylabel('b');
set(H,'FontSize',14);
H = title('Least Squares Cost Function');
set(H,'FontSize',14);

