function o = AnnealGet(options,name,default)
%ANNEALGET Get ANNEAL OPTIONS parameters.
%   VAL = ANNEALGET(OPTIONS,'NAME') extracts the value of the named parameter
%   from optimization options structure OPTIONS, returning an empty matrix if
%   the parameter value is not specified in OPTIONS.  It is sufficient to
%   type only the leading characters that uniquely identify the
%   parameter.  Case is ignored for parameter names.  [] is a valid OPTIONS
%   argument.
%   
%   VAL = ANNEALGET(OPTIONS,'NAME',DEFAULT) extracts the named parameter as
%   above, but returns DEFAULT if the named parameter is not specified (is [])
%   in OPTIONS.  For example
%   
%     val = AnnealGet(opts,'TolX',1e-4);
%   
%   returns val = 1e-4 if the TolX property is not specified in opts.
%   
%   See also ANNEALSET.

%   Copyright (c) 1984-98 by The MathWorks, Inc.
%   $Revision: 1.2 $  $Date: 2004/03/24 21:00:40 $

%  THINGS TO CHANGE WHEN ADDING OPTIONS:
%     (1) Name list

if nargin < 2
  error('Not enough input arguments.');
end
if nargin < 3
  default = [];
end

if ~isempty(options) & ~isa(options,'struct')
  error('First argument must be an options structure created with ANNEALSET.');
end

if isempty(options)
  o = default;
  return;
end

Names = [
   'Display           '
   'Schedule          '
   'TInitial          '
   'TFactor           '
   'NumSteps          '
   'Qfactor           '
   'Restart           '
   'MaxFunEvals       '
   'MaxIter           '
   'TolFun            '
   'TolX              '
   'BestSave          '
    ];
[m,n] = size(Names);
names = lower(Names);

lowName = lower(name);
j = strmatch(lowName,names);
if isempty(j)               % if no matches
  error(sprintf(['Unrecognized property name ''%s''.  ' ...
                 'See ANNEALSET for possibilities.'], name));
elseif length(j) > 1            % if more than one match
  % Check for any exact matches (in case any names are subsets of others)
  k = strmatch(lowName,names,'exact');
  if length(k) == 1
    j = k;
  else
    msg = sprintf('Ambiguous property name ''%s'' ', name);
    msg = [msg '(' deblank(Names(j(1),:))];
    for k = j(2:length(j))'
      msg = [msg ', ' deblank(Names(k,:))];
    end
    msg = sprintf('%s).', msg);
    error(msg);
  end
end

if any(strcmp(fieldnames(options),deblank(Names(j,:))))
  eval(['o = options.' Names(j,:) ';']);
  if isempty(o)
    o = default;
  end
else
  o = default;
end

