function pdata = GenPolyData(pdata)
% Test Model Selection
% function pdata = GenPolyData

if nargin == 0
  figure(1);
  subplot(1,1,1);
  
  plotboundingbox;
  deg = 0;
  while(deg+1)
    [x(deg+1),y(deg+1)] = ginput(1);
    if x(deg+1) < 0 | y(deg+1) < 0 | x(deg+1) > 1 | y(deg+1) > 1
       deg = -1;
    else
       P = polyfit(x,y,deg);
       plotboundingbox
       plot(x,y,'*r');
       plot(0:.001:1,polyval(P,0:.001:1),'r');
       title(['Degree ',num2str(deg)]);
       deg = deg + 1;
    end
  end
  x = x(1:end-1)
  y = y(1:end-1)
  deg = numel(x) - 1;
else
  P = pdata.Polynomial;
  deg = numel(P) - 1;
end
disp(['True Model has DEGREE ',num2str(deg)]);
NoiseLevel = input('Input Noise Level: ');
NumPoints = input('Input Number of Data Points: ');
seed = input('Input Random Seed: ');

randn('state',seed);
rand('state',seed)
Xdata = rand(1,NumPoints);
Ydata = polyval(P,Xdata) + NoiseLevel*randn(1,NumPoints);
plotboundingbox
plot(0:.001:1,polyval(P,0:.001:1),'r');
title(['True Degree ',num2str(deg)]);
plot(Xdata,Ydata,'k*');

pdata.Xdata = Xdata;
pdata.Ydata = Ydata;
pdata.Polynomial = P;
pdata.NoiseLevel = NoiseLevel;
pdata.Seed = seed;

function plotboundingbox
% Plot plusses around the unit box in first quadrant
hold off
plot([0,1,1,0],[0,0,1,1],'+'); 
axis([0,1,0,1]);
hold on
