function BICselect(pdata)

NumPoints = numel(pdata.Xdata);
deg = 0; 
while (deg>=0 & deg<=NumPoints-1)
  [P,S] = polyfit(pdata.Xdata,pdata.Ydata,deg);
  loglike = NumPoints*log(1/(pdata.NoiseLevel*sqrt(2*pi))) ...
            - 1/(2*pdata.NoiseLevel^2)*S.normr^2;
  BIC(deg+1) = (deg+1)*log(NumPoints) - 2*loglike;

  if (deg == 0)
    disp(['Degree: ',num2str(deg),' BIC: ',num2str(BIC(deg+1)),': BASELINE']);
  elseif BIC(deg + 1) < BIC(deg)
    disp(['Degree: ',num2str(deg),' BIC: ',num2str(BIC(deg+1)),': BETTER']);
  else
    disp(['Degree: ',num2str(deg),' BIC: ', num2str(BIC(deg+1)),': WORSE']);
    break
  end  
  deg = deg + 1;
end
disp(['BIC deems the answer DEGREE ',num2str(deg - 1)]);
disp(['RECALL: The polynomial that generated the data had DEGREE ',...
       num2str(numel(pdata.Polynomial)-1)]);

